/*
$DESCRIPTION		: Sound Response functionality 

$Copyright			: CRATUS TECHNOLOGY INC, 2015-16 

$Project			: CUBE

$Author				: Dhruv

*/

/*! 
	\file	CUBE_timers.c
 *
 * @defgroup CUBE_timers	WIQB Timer Module
 * @{
 * @ingroup CUBE_timers	WIQB Timer Module
 * @brief File contains all timer related functions 
 */
 
/* INCLUDE FILES */
#include <stdint.h>
#include <stdbool.h>
#include "softdevice_handler.h"
#include "app_timer.h"
#include "nrf_drv_timer.h"
#include "nrf_timer.h"
#include "nrf_drv_timer.h"
#include "app_scheduler.h"
#include "nrf_delay.h"
#include "CUBE_ble_cmn.h"
#include "CUBE_BLE_lightingPattern.h"
#include "CUBE_timers.h"
#include "CUBE_IO_LED.h"
#include "CUBE_IO_ACCL.h"
#include "CUBE_IO_MIC.h"
#include "CUBE_IO_BAT.h"
#include "CUBE_APP_LightingController.h"
#include "cmsis_os.h"
#include "CUBE_BLE_Reliable_Write.h"
#include "CUBE_IO_Motor.h"
#include "nrf_drv_ppi.h"
#include "nrf_adc.h"
#include "arm_math.h"
#include "CUBE_APP_SoundResponse.h"

/* MODULE EXTERNAL DATA DEFINITIONS        *ddddddd*/
  SoundResponseState_t ge_SoundResponseState;

/* MODULE INTERNAL CONSTANT DEFINITIONS    *ccccccc*/

/* MODULE INTERNAL TYPE DEFINITIONS        *ttttttt*/
typedef struct
{
	uint32_t	mu32_TotalPower;
	
	uint32_t	mu32_AveragePower;
	
	uint32_t	mu32_PeakPower;
	
	uint16_t 	mu16_PowerLevel;
	
	uint16_t  mu16_DiffPowerLevel;
	
}ComputedAudioParams_t;

ComputedAudioParams_t gs_ProcessedAudioParams;

/* MODULE INTERNAL MACRO DEFINITIONS       *mmmmmmm*/

/* MODULE INTERNAL FUNCTION PROTOTYPES     *fffffff*/

/** Functions for BLE Notifications Timer **/

/** Functions for LED Timer **/
/*!
    \brief 		Function to create timer for LED fading
*/


/* MODULE INTERNAL DATA DEFINITIONS        *ddddddd*/

/******************************************* Timers used in the cube Firmware are converted as Threads ******************************/


extern volatile int32_t MIC_adc_sample;
extern volatile uint32_t adc_sample[ADC_SAMPLE_BUFFER_LENGTH];
extern volatile int16_t gas16_ADCBuffer[2][ADC_SAMPLE_BUFFER_LENGTH];

extern volatile int32_t Signed_MIC_adc_sample;

extern ble_rw_t    		  m_res;         /**< Structure to identify the Reliable write serivce. */
extern volatile uint8_t Sound_Enable;
extern volatile uint8_t Sound_Disable;


extern volatile uint8_t CUBE_Sound_Pattern;
extern lp_patterns_t ge_currentLightingPattern;

///////////////////////////////////////// Defining the color matrix for the audio testing  ////////////////////////////////////////



/////////////////////////////////////// Creating the PPI channel between ADC and TIMER2 ///////////////////////////////////////////
/*

*  Configure the TIMER2 and ADC.
*  Configure PPI channel to connect the TIMER2 Interrupt event with the ADC start task
*  Start the TIMER2 in order to get periodic events and periodic ADC samples
*  The TIMER2, PPI and ADC operations are pure hardware operations, so the CPU will sleep while all this is happening.
*  When the ADC is finished sampling, the ADC interrupt handler will execute which wakes up the CPU.

*/


#define NO_OF_PALLETS			10
#define AVERAGE_POWER_COLOR 	8
#define DIFF_POWER_COLOR 		8



// RGB_LED   color_matrix[MAX_COLORINDEX_LEN]  = {{30,240,0},
//{60,210,0},
//{90,180,0},
//{120,150,0},
//{150,120,0},
//{180,90,0},
//{210,60,0},
//{240,30,0}, 
//{240,30,0},
//{210,60,0},
//{180,90,0},
//{150,120,0},
//{120,150,0},
//{90,180,0},
//{60,210,0},
//{30,240,0}};


//{{81,233,0},
//{231,23,68},
//{150,100,50},
//{80,72,230},
//{250,104,25},
//{250,163,25},
//{253,226,23},
//{255,190,50}};

RGB_LED   gas_ColorTable[NO_OF_PALLETS][AVERAGE_POWER_COLOR][DIFF_POWER_COLOR] = 
{
//#include "Pallet_with_lumen_0.34.dat" // Approved - 1
//#include "Pallet_with_lumen_0.50.dat"	// Approved - 2
//#include "Pallet_with_lumen_0.70.dat"
//#include "ColorPallet_I_0.35_v1"
#include "Pallet_with_lumenTest.dat"

};




///////////////////////////////////////// Defining the message queue for the threads communication ////////////////////////////////




//osPoolDef(mpool, 24, RGB_LED);                    // Define memory pool
//osPoolId  mpool;
RGB_LED gRGB_ColorIndex = {0};

void readColorFromTable(void);
uint8_t curColorIndex = 0;
void readCSVfile(void);


/*Moving Average filter implementation for the simple band pass filter for the Audio response.
**/



//q31_t prev_avg = 0;
//bool set_flag = false;
//uint32_t begin = 0;
//int buffer[8] = {0};
//uint8_t filter_len = 8;
//uint32_t index_filter = 0;
//q31_t avg = 0;
//float pwm_for_led = 1.0;

/////////////////////////////////////// Creating the PPI channel between ADC and TIMER2 ///////////////////////////////////////////
/*

*  Configure the TIMER2 and ADC.
*  Configure PPI channel to connect the TIMER2 Interrupt event with the ADC start task
*  Start the TIMER2 in order to get periodic events and periodic ADC samples
*  The TIMER2, PPI and ADC operations are pure hardware operations, so the CPU will sleep while all this is happening.
*  When the ADC is finished sampling, the ADC interrupt handler will execute which wakes up the CPU.

*/



/** Functions for the Hardware TIMER2 **/
/*!
    \brief 		The intention to create this timer is to 
*/

const nrf_drv_timer_t gcs_HWTimer2 = NRF_DRV_TIMER_INSTANCE(2);	// THis is the timer handle for the Hardware Timer 2.

static void CUBE_IO_HWTimer2Start(void);
static void CUBE_IO_HWTimer2Init(void);
static void CUBE_IO_HWTimer2EventHandler(nrf_timer_event_t event_type , void* p_context);


/*
* PPI Configuration to connect TIMER2 and ADC hardware.
* Here, PPI channel 0 is used.
*/

nrf_ppi_channel_t ppi_channel0;
void CUBE_ppi_init(void);

/** @brief Function for initializing the PPI peripheral for the ADC and TIMER2 hardware.
*/
void CUBE_ppi_init(void)
{
	uint32_t err_code = NRF_SUCCESS;
	
    err_code = nrf_drv_ppi_init();
    APP_ERROR_CHECK(err_code);
	
    // Configure 1st available PPI channel to start the ADC conversion on TIMER1 COMPARE[0] match. THe timing need to be calculated
    err_code = nrf_drv_ppi_channel_alloc(&ppi_channel0);
    APP_ERROR_CHECK(err_code);
    err_code = nrf_drv_ppi_channel_assign(ppi_channel0,
                                          nrf_drv_timer_event_address_get(&gcs_HWTimer2, NRF_TIMER_EVENT_COMPARE0),
                                          nrf_drv_adc_task_address_get(NRF_ADC_TASK_START));
    APP_ERROR_CHECK(err_code);
	
    // Enable configured PPI channel
    err_code = nrf_drv_ppi_channel_enable(ppi_channel0);
    APP_ERROR_CHECK(err_code);
}


// Timer even handler. Not used since timer is used only for PPI.
void CUBE_IO_HWTimer2EventHandler(nrf_timer_event_t event_type , void* p_context){}

/** @brief Function for Timer 2 initialization.
 *  @details Initializes Timer 2 peripheral, creates event and interrupt every 250 us 
 *           by configuring CC[0] to timer overflow value. Events are created  This event can be used to start Timer 0
 *           with Timer2->Event_Compare[0] triggering ADC start conversion.
*/
#define		SAMPLING_RATE	    8000
#define		SAMPLING_PERIOD	  125			//	125uS
	
static void CUBE_IO_HWTimer2Init(void)
{
	uint32_t 	lu32_TargetValue=0;
	
	nrf_drv_timer_config_t Timer2Config;
	Timer2Config.bit_width = NRF_TIMER_BIT_WIDTH_16;
	Timer2Config.frequency = NRF_TIMER_FREQ_1MHz;
	ret_code_t err_code = nrf_drv_timer_init(&gcs_HWTimer2, &Timer2Config, CUBE_IO_HWTimer2EventHandler);
	APP_ERROR_CHECK(err_code);

	//	In order to sample at 8 Khz, the delay needed is 125 uS (1/8000). Given that timer frequency is  MHz, comparator value will be 125
	// lu32_TargetValue = 125;
	
	nrf_drv_timer_extended_compare(&gcs_HWTimer2,
									NRF_TIMER_CC_CHANNEL0,
									SAMPLING_PERIOD,
									NRF_TIMER_SHORT_COMPARE0_CLEAR_MASK,
									false);
	
}

/** @brief Function for enabling  hardware timer 2.
 *  @details Initializes Timer 2 peripheral, creates event and interrupt every 125 us 
 *           by configuring CC[0] to timer overflow value. Events are created  This event can be used to start Timer 0
 *           with Timer2->Event_Compare[0] triggering ADC start conversion.
*/


void CUBE_IO_HWTimer2Start(void)
{
	 nrf_drv_timer_enable(&gcs_HWTimer2);
}

/** @brief Function for stopping  hardware timer 2.
 *  @details Stops data acquisition cycles
*/
void CUBE_IO_HWTimer2Stop(void)
{
	 nrf_drv_timer_disable(&gcs_HWTimer2);
}


/* EXPORTED (GLOBAL or External) FUNCTIONS *ggggggg*/

/*!
    \fn 		readColorFromTable()
	\brief 		Function to get the current color index from the Color table.

	\details 	This function will select one color index from the Color Table and will return the address of that color index.
		
    \param[in] 	lp_rgb_data_t*         
					
    \return	    NONE 	

    \note		

*/
RGB_LED*  ptr_colorIndex = NULL;

extern osThreadId CUBE_APP_SoundResponseThread_id;
extern volatile 	uint32_t  gu32_Connected;
extern osMessageQId  LED_MsgBox;
extern void CUBE_APP_EnterSoundResponseThreadConfig(void);
extern void CUBE_APP_ExitSoundResponseThreadConfig(void);

volatile bool gu32_SoundResponseIsActive = false;
volatile uint32_t gu32_SoundResponseStatus = false;

#define	NUMBER_OF_POWER_LEVELS	8
const uint16_t cau16_PowerLevelTable[NUMBER_OF_POWER_LEVELS][3]=
{
	0,	0,	101,		//	<= -18 dB
	1,	352, 160,		//	-18 dB to -16 dB
	2,	161, 254,		//	-16 dB to -14 dB
	3,	255, 403,		//	-14 dB to -12 dB
	4,  404, 805,		//	-12 dB to -9 dB
	5,  806, 1607,		//	-9 dB to -6 dB
	6,  1608, 3207,	//	-6 dB to -3 dB
	7,	3207, 6400//	- 3 dB and Above 
};


//// Note the Max value is : 240
//const uint16_t cau16_PowerLevelTable[NUMBER_OF_POWER_LEVELS][3]=
//{
//	0,	0,	912,		//	<= -18 dB
//	1,	913, 1446,		//	-18 dB to -16 dB
//	2,	1447, 2293,		//	-16 dB to -14 dB
//	3,	2294, 3634,		//	-14 dB to -12 dB
//	4,  3635, 7251,		//	-12 dB to -9 dB
//	5,  7252, 14468,		//	-9 dB to -6 dB
//	6,  14469, 28868,	//	-6 dB to -3 dB
//	7,	28869, 57600//	- 3 dB and Above 
//};

// Note the Max value is : 171
//const uint16_t cau16_PowerLevelTable[NUMBER_OF_POWER_LEVELS][3]=
//{
//	0,	0,	463,		//	<= -18 dB
//	1,	464, 734,		//	-18 dB to -16 dB
//	2,	735, 1164,		//	-16 dB to -14 dB
//	3,	1165, 1844,		//	-14 dB to -12 dB
//	4,  1845, 3681,		//	-12 dB to -9 dB
//	5,  3682, 7345,		//	-9 dB to -6 dB
//	6,  7346, 14655,	//	-6 dB to -3 dB
//	7,	14656, 29241//	- 3 dB and Above 
//};


/*!
    \fn 		CUBE_APP_ProcessAudioSignal()
	\brief 		Function to process the audio signal and 

	\details 	This function processes the audio signal from the buffer that is ready
				and provides output to the LED Control engine
	
    \param[in] 	int16_t* : Pointer to the buffer containing signed samples of audio         
					
    \return	    NONE 	

    \note		

*/


void CUBE_APP_ProcessAudioSignal(int16_t* rps16_AudioSamples, ComputedAudioParams_t *rps_AudioPrams)
{
	uint32_t lu32_LoopCount=0;
	int32_t ls32_TotalPower=0;
	uint32_t lu32_PeakPower=0;
	int32_t ls32_Power=0;
	int16_t  ls16_SampleValue=0;
	uint32_t lu32_AveragePower=0;
	uint16_t lu16_PowerLevel=0;
	uint32_t lu32_DiffPower=0;
	
	for(lu32_LoopCount=0; lu32_LoopCount < ADC_SAMPLE_BUFFER_LENGTH; lu32_LoopCount++)
	{
		ls16_SampleValue = rps16_AudioSamples[lu32_LoopCount];
		
		//	Compute instantaneous power, total power to compute average power and peak power
		ls32_Power = ls16_SampleValue*ls16_SampleValue;
		ls32_TotalPower += ls32_Power;
		
		//	Keep checcking for peak power
		lu32_PeakPower = (ls32_Power > lu32_PeakPower) ? ls32_Power : lu32_PeakPower; 
		
		//	Perform Zero-Cross detection
	}
	
	//	Compute the average power
	lu32_AveragePower = (ls32_TotalPower/ADC_SAMPLE_BUFFER_LENGTH);
	
	lu32_DiffPower  =  (lu32_PeakPower - lu32_AveragePower) >> 1; 
	
	//	Based on the average power, find out the power level the signal belongs to
	for(lu16_PowerLevel=0; lu16_PowerLevel < NUMBER_OF_POWER_LEVELS; lu16_PowerLevel++)
	{
		if(lu32_AveragePower  > cau16_PowerLevelTable[lu16_PowerLevel][2])
			continue;
		else
			break;
	}
	rps_AudioPrams->mu16_PowerLevel = lu16_PowerLevel;

	//avg_bufferForPowerDebug[index_count] = lu16_PowerLevel << 16; 
	lu16_PowerLevel = 0;
		//	Based on the average power, find out the power level the signal belongs to
	for(lu16_PowerLevel=0; lu16_PowerLevel < NUMBER_OF_POWER_LEVELS; lu16_PowerLevel++)
	{
		if(lu32_DiffPower  > cau16_PowerLevelTable[lu16_PowerLevel][2])
			continue;
		else
			break;
	}
	
	//avg_bufferForPowerDebug[index_count] = avg_bufferForPowerDebug[index_count] | lu16_PowerLevel;
	rps_AudioPrams->mu16_DiffPowerLevel = lu16_PowerLevel;
	//	Update the block with computed parameters
	
	rps_AudioPrams->mu32_PeakPower = lu32_PeakPower;
	rps_AudioPrams->mu32_AveragePower = lu32_AveragePower;

}


uint32_t prev_diff = 0 ;
uint32_t diff = 0;

void  CUBE_Trigger_Old_Patterns(uint8_t Second_pattern_type[][6], uint8_t index)
{
	

	diff = gs_ProcessedAudioParams.mu32_AveragePower;

	if ( diff < (prev_diff* 1.15)  &&  diff >= (prev_diff* 1.10))
		{
			CUBE_IO_LEDControl(RED_LED_CORNER_4 , Second_pattern_type[index][0]);
			CUBE_IO_LEDControl(GREEN_LED_CORNER_4 , Second_pattern_type[index][1]);
			CUBE_IO_LEDControl(BLUE_LED_CORNER_4 , Second_pattern_type[index][2]);
		}
	else if(diff < (prev_diff* 1.20)  &&  diff >= (prev_diff* 1.15))
		{
			CUBE_IO_LEDControl(RED_LED_CORNER_4 , Second_pattern_type[index][3]);
			CUBE_IO_LEDControl(GREEN_LED_CORNER_4 , Second_pattern_type[index][4]);
			CUBE_IO_LEDControl(BLUE_LED_CORNER_4 , Second_pattern_type[index][5]);
		}
	else if(diff < (prev_diff* 1.25)  &&  diff >= (prev_diff* 1.20))
		{
			CUBE_IO_LEDControl(RED_LED_CORNER_3 , Second_pattern_type[index][0]);
			CUBE_IO_LEDControl(GREEN_LED_CORNER_3 , Second_pattern_type[index][1]);
			CUBE_IO_LEDControl(BLUE_LED_CORNER_3 , Second_pattern_type[index][2]);
		}
	else if(diff < (prev_diff* 1.30)  &&  diff >= (prev_diff* 1.25))
		{
			CUBE_IO_LEDControl(RED_LED_CORNER_3 ,Second_pattern_type[index][3]);
			CUBE_IO_LEDControl(GREEN_LED_CORNER_3 , Second_pattern_type[index][4]);
			CUBE_IO_LEDControl(BLUE_LED_CORNER_3 , Second_pattern_type[index][5]);
		}
	else if(diff > (prev_diff* 0.95)  &&  diff <= (prev_diff* 1.00))
		{
			CUBE_IO_LEDControl(RED_LED_CORNER_2 , Second_pattern_type[index][0] );
			CUBE_IO_LEDControl(GREEN_LED_CORNER_2 , Second_pattern_type[index][1]);
			CUBE_IO_LEDControl(BLUE_LED_CORNER_2 , Second_pattern_type[index][2]);
		}
	else if(diff > (prev_diff* 0.90)  &&  diff <= (prev_diff* 0.95))
		{
			CUBE_IO_LEDControl(RED_LED_CORNER_2 , Second_pattern_type[index][3]);
			CUBE_IO_LEDControl(GREEN_LED_CORNER_2 , Second_pattern_type[index][4]);
			CUBE_IO_LEDControl(BLUE_LED_CORNER_2 , Second_pattern_type[index][5]);
		}
	else if(diff > (prev_diff* 0.85)  &&  diff <= (prev_diff* 0.90))
		{
			CUBE_IO_LEDControl(RED_LED_CORNER_1 , Second_pattern_type[index][0]);
			CUBE_IO_LEDControl(GREEN_LED_CORNER_1 , Second_pattern_type[index][1]);
			CUBE_IO_LEDControl(BLUE_LED_CORNER_1 ,Second_pattern_type[index][2]);
		}
	else if(diff > (prev_diff* 0.80)  &&  diff <= (prev_diff* 0.85))
		{
			CUBE_IO_LEDControl(RED_LED_CORNER_1 ,Second_pattern_type[index][3]);
			CUBE_IO_LEDControl(GREEN_LED_CORNER_1 , Second_pattern_type[index][4]);
			CUBE_IO_LEDControl(BLUE_LED_CORNER_1 , Second_pattern_type[index][5]);
		}	
	
	prev_diff = diff;
		
}


uint8_t Second_pattern_array[10][6] = {
{0, 145 , 0, 200, 0, 200}, // P11 Classic-- Ok
{106, 57, 55, 255, 0, 0} , // P12 -- Love
{255, 10, 0, 180, 100, 0},   // P13 Rising Sun - ok
{255,255,0,50,100,0},  // P14 - CAndle  ok
{67,87,173,0,215,100}, // P15 = Water Ok 
{50,150,0,200,0,117},   // P -16 Party 
{251,139,36,0,200,222}, // P -17 Tokyo - ok
{80,120,0,0,255,0},  // P - 18Forest - ok
 {50,150,0,200,0,117},// P - 19Autumn
{0,0,255,0,100,150} // P -20 Sea - ok 
};

//uint8_t counter_log = 0;
//uint8_t adc_level_data[20];

/*!
    \fn 		CUBE_APP_SoundResponseThread()
	\brief 		Function which will perform sound response functionality

	\details 	
		
    \param[in] 	lp_rgb_data_t*         
					
    \return	    NONE 	

    \note		NOTES on Inter-Thread communication

		*Entry and Exit point for the thread
			-ENTRY
				:SOUND_RESPONSE_ON_SIGNAL is set from lp_command_write_handler()
			-EXIT
				:SOUND_RESPONSE_OFF_SIGNAL is set from lp_command_write_handler()
				
		*Providing the LED output pattern to LED Controller Thread
			-Message through Queue
			
		*Communication between ADC driver and thread
			-ADC_BUFFER1_FULL_SIGNAL is set to communicate that the computation can be done on ADC_BUFFER1
			-ADC_BUFFER2_FULL_SIGNAL is set to communicate that the computation can be done on ADC_BUFFER2
*/
void CUBE_APP_SoundResponseThread(void const * arg)
{
	osEvent ls_SoundResponseThreadEvent;
	osStatus evt1;
	RGB_LED*  lps_PointerToRGBValues=NULL; 
	int32_t signal_ena;
	uint32_t lu32_EventToBeHandled;
	
	//	Sound Response is INACTIVE
	ge_SoundResponseState = SOUND_RESPONSE_INACTIVE;
	
	// This function call initiales Hardware timer 2. 
	CUBE_IO_HWTimer2Init();
	
	//	TO DO: Can this be initialized inside SoundResponse Thread?
	CUBE_MIC_adc_config();
	//CUBE_MIC_adc_start();

	
	while(1)
	{
		

		/*
			SoundResponse Thread Entry and Exit logic
				- Execute the functionality as long as SOUND_RESPONSE_ON_SIGNAL is set
				- At the end of the loop set SOUND_RESPONSE_ON_SIGNAL 
				- Also, check if SOUND_RESPONSE_OFF_SIGNAL has been set from lp_command_write_handler()
				- If so, do NOT SOUND_RESPONSE_ON_SIGNAL, exit from the thread  
		
		*/
		
		ls_SoundResponseThreadEvent = osSignalWait(ANY_SIGNAL, osWaitForever);
		
		lu32_EventToBeHandled = ls_SoundResponseThreadEvent.value.signals;
		
		//	If the CUBE is disconnected state, get all the LEDs to OFF state			
		if( (ge_SoundResponseState == SOUND_RESPONSE_DEACTIVATE_COMMAND_RECEIVED) ||
			(gu32_Connected == 0)  
			)
		{
			lu32_EventToBeHandled = SOUND_RESPONSE_OFF_SIGNAL;
		}
		
		switch(lu32_EventToBeHandled)
		{
			case SOUND_RESPONSE_ON_SIGNAL:
			{
				//	This is the first time that the signal has been received to begin sound response
				//	Terminate un-needed threads to maximize available CPU time
				CUBE_APP_EnterSoundResponseThreadConfig();
			
				// Strats the  Hardware Timer. This begins data acqusition from ADC 
				CUBE_IO_HWTimer2Start();
				
				//	Set the state variable to indicate that Sound Response is Active
				gu32_SoundResponseIsActive = true;
				
				//	Go back to the loop again
				//continue;
				
			}
			break;
			
			case SOUND_RESPONSE_OFF_SIGNAL:
			//case (SOUND_RESPONSE_OFF_SIGNAL+ADC_BUFFER1_FULL_SIGNAL):
			//case (SOUND_RESPONSE_OFF_SIGNAL+ADC_BUFFER2_FULL_SIGNAL):
			{
				//	Stop the timer so that triggering of ADC Interrupt is stopped
				CUBE_IO_HWTimer2Stop();
				prev_diff = 0;
				diff = 0;
				
				//	Stop data acquisition from microphone
				CUBE_IO_MIC_StopDataAcquisition();	
				
				//	Turn OFF all LEDs
				CUBE_IO_LEDControl(ALL_LEDS_OFF , 0);
				
				// Device is slave
				device_param_setAsSlave();
	
				// deactivate any pattern that is currently running
				CUBE_IO_deactivatePatterns();		
				
				//	Set the state variable to indicate that Sound Response is NOT Active
				gu32_SoundResponseIsActive = false;
				
				//	Start BLE Notify Thread and Accelerometer thread
				CUBE_APP_ExitSoundResponseThreadConfig();				
				
				//	Finally, reflect that SOUND RESPONSE is inactive
				ge_SoundResponseState = SOUND_RESPONSE_INACTIVE;
			}
			break;
			
			case ADC_BUFFER1_FULL_SIGNAL:
			{
				//	Indication from ADC driver that Buffer1 is ready to be processed.
				//	Process the audio signal and get the parameters
				CUBE_APP_ProcessAudioSignal((int16_t *)gas16_ADCBuffer[0], &gs_ProcessedAudioParams);
				
			}
			break;
			
			case ADC_BUFFER2_FULL_SIGNAL:
			{
				//	Indication from ADC driver that Buffer2 is ready to be processed
				CUBE_APP_ProcessAudioSignal((int16_t *)gas16_ADCBuffer[1], &gs_ProcessedAudioParams);
			}
			break;
   									
		}// End
		
		//	This is a fail safe scenario to ensure that no residual ADC_BUFFER FULL event triggers activation
		//	of LEDs
		if((ls_SoundResponseThreadEvent.value.signals == ADC_BUFFER1_FULL_SIGNAL) ||
			(ls_SoundResponseThreadEvent.value.signals == ADC_BUFFER2_FULL_SIGNAL) 
		  )
		{
			if(gs_ProcessedAudioParams.mu16_PowerLevel <= 7 )
			{
				
				if(CUBE_Sound_Pattern <= 9)
				{
					// Map the processed audio parameters to color table
					ptr_colorIndex = &gas_ColorTable[CUBE_Sound_Pattern][gs_ProcessedAudioParams.mu16_PowerLevel][gs_ProcessedAudioParams.mu16_DiffPowerLevel];	
				}
				
				if(lu32_EventToBeHandled == SOUND_RESPONSE_OFF_SIGNAL)
				{
					prev_diff = 0;
					diff = 0;
				}
				
				else if(10 <= CUBE_Sound_Pattern < 20)
				{
					CUBE_Trigger_Old_Patterns(Second_pattern_array , CUBE_Sound_Pattern - 10);			
				}
						
			
			}
			
			

			
//			adc_level_data[counter_log] = gs_ProcessedAudioParams.mu16_PowerLevel;
//			counter_log = counter_log  + 1;
//			adc_level_data[counter_log] = gs_ProcessedAudioParams.mu16_DiffPowerLevel;	
//			counter_log = counter_log  + 1;
//			
//			if(counter_log == 20)
//				{
//				
//				uint32_t       err_code;
//				err_code = ble_DATA_OUT_send(&m_res, adc_level_data, 20);
//				for(int i = 0 ; i < 20;  i++)
//				{
//					adc_level_data[i] = 0;
//				}
//				counter_log = 0;
//				if (err_code != NRF_ERROR_INVALID_STATE)
//				 {
//					 APP_ERROR_CHECK(err_code);
//				 }
//			}
			
			
			
			
			// Push pointer to the value as a message in to the queue
			evt1 = osMessagePut(LED_MsgBox, (uint32_t )ptr_colorIndex, osWaitForever);  // Send Message
			if(evt1 == osErrorResource)
			{
				//NVIC_SystemReset();
			}
		}
		
		CUBE_BAT_monitor();
		
		
	}
	
}
